CREATE OR REPLACE VIEW V_ALL_I_TRANSACTION AS
SELECT id, account_from, account_to, var_sym, amount, created, status, trans_type
FROM   TRANSACTION
-- transakcia musi byt nad uctom nastavenym v kontexte
WHERE  account_from = sys_context('bank_context', 'account_no')
-- vlozit mozeme iba novu transakciu
AND    status = 'NEW'
-- suma transakcie nesmie presiahnut rozdiel sumy na ucte a sucetu novych transakcii
AND    amount <= (SELECT balance
                  FROM   account acc
                  WHERE  acc.account_no = sys_context('bank_context', 'account_no')) -
       (SELECT nvl(SUM(amount), 0)
                  FROM   TRANSACTION
                  WHERE  account_from = sys_context('bank_context', 'account_no')
                  AND    status = 'NEW')
-- ak je zamestnanec neobmedzujeme vysku transakcie, typ transakcie musi byt TELLER_PAY
AND    ((sys_context('bank_context', 'user_type') = 'EMP' AND trans_type = 'TELLER_PAY') OR
-- ak je klient, musi to byt platba typu EBANK_PAY, suma dnesnych transakcii typu EBANK_PAY  nesmie presiahnut dany limit
      (sys_context('bank_context', 'user_type') = 'CLIENT' AND
      (trans_type = 'EBANK_PAY' AND
      amount <= (SELECT day_limit
                     FROM   account acc
                     WHERE  acc.account_no = sys_context('bank_context', 'account_no')) -
      (SELECT nvl(SUM(amount), 0)
                     FROM   TRANSACTION
                     WHERE  account_from = sys_context('bank_context', 'account_no')
                     AND    created > trunc(SYSDATE)
                     AND    status <> 'CANCELED'
                     AND    trans_type = 'EBANK_PAY'))) OR
-- ak je terminal, musi to byt platba typu CARD_ATM alevo CARD_PAY pricom sumy dnesnych transakcii sa musia zmesit do stanoveneho limitu
      (sys_context('bank_context', 'user_type') = 'TERMINAL' AND
      ((trans_type = 'CARD_ATM' AND
      amount <= (SELECT atm_limit
                      FROM   card
                      WHERE  account_no = sys_context('bank_context', 'account_no')
                      AND    valid = 1) -
      (SELECT nvl(SUM(amount), 0)
                      FROM   TRANSACTION
                      WHERE  account_from = sys_context('bank_context', 'account_no')
                      AND    created > trunc(SYSDATE)
                      AND    status <> 'CANCELED'
                      AND    trans_type = 'CARD_ATM')) OR
      (trans_type = 'CARD_PAY' AND
      amount <= (SELECT pay_limit
                      FROM   card
                      WHERE  account_no = sys_context('bank_context', 'account_no')
                      AND    valid = 1) -
      (SELECT nvl(SUM(amount), 0)
                      FROM   TRANSACTION
                      WHERE  account_from = sys_context('bank_context', 'account_no')
                      AND    created > trunc(SYSDATE)
                      AND    status <> 'CANCELED'
                      AND    trans_type = 'CARD_PAY')))))
-- grant insert on v_all_i_transaction to teller
-- grant insert on v_all_i_transaction to client
-- grant insert on v_all_i_transaction to terminal
WITH CHECK OPTION
/
grant insert on V_ALL_I_TRANSACTION to CLIENT;
grant insert on V_ALL_I_TRANSACTION to TELLER;
grant insert on V_ALL_I_TRANSACTION to TERMINAL;


